﻿using Hims.Shared.Dapper.Attributes;
using Hims.Shared.Library.Enums;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Shared.EntityModels
{
    /// <summary>
    /// The anc card generation model.
    /// </summary>
    public class GYNCardGenerationModel
    {
        /// <summary>
        /// Gets or sets the anc card generation identifier.
        /// </summary>
        public int? GYNCardGenerationId { get; set; }
        public bool IsAdmission { get; set; }
        /// <summary>
        /// Gets or sets department
        /// </summary>
        public string? Department { get; set; }
        /// <summary>
        /// Gets or sets anc no.
        /// </summary>
        public string? GYNNo { get; set; }
        /// <summary>
        /// Gets or sets the husband name.
        /// </summary>
        public string? HusbandName { get; set; }

        /// <summary>
        /// Gets or sets the remark.
        /// </summary>
        public string? Remarks { get; set; }
        /// <summary>
        /// Gets or sets the registration date.
        /// </summary>
        public string? RegistrationDate { get; set; }
        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool? Active { get; set; }
        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }
        /// <summary>
        /// Gets or sets the patient Id.
        /// </summary>
        public int PatientId { get; set; }
        /// <summary>
        /// Gets or sets the husband age.
        /// </summary>
        public int? HusbandAge { get; set; }
        /// <summary>
        /// Gets or sets anc no exist.
        /// </summary>
        public string? GYNNoExists { get; set; }
        /// <summary>
        /// Gets or sets appointment Id.
        /// </summary>
        public int? AppointmentId { get; set; }

        public DateTime? AppointmentDate { get; set; }

        public TimeSpan? AppointmentTime { get; set; }

        public string? ProviderName { get; set; }   

       
        public string? JsonString { get; set; }
        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public GynEncounterType Type { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int ModifiedBy { get; set; }

        public int? ObEncounterId { get; set; }

        public string? OtherDetails { get; set; }
        public string? ConsultantDoctor { get; set; }
    }
    //public class OrderPrescriptions
    //{
    //    public int? AppointmentId { get; set; }

    //    public string? OrderPrescription { get; set; }

    //    public DateTime? AppointmentDate { get; set; }
    //    public TimeSpan? AppointmentTime { get; set; }

    //    public string? ProviderName { get; set; }
    //}
}
